/*
 * Decompiled with CFR 0.152.
 */
package com.idl.javaidl;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Date;

public class JIDLEvent {
    private long m_hwnd;
    private int m_msg;
    private int m_wp;
    private int m_lp;
    protected static final int WM_MOUSEMOVE = 512;
    protected static final int WM_LBUTTONDOWN = 513;
    protected static final int WM_LBUTTONUP = 514;
    protected static final int WM_LBUTTONDBLCLK = 515;
    protected static final int WM_RBUTTONDOWN = 516;
    protected static final int WM_RBUTTONUP = 517;
    protected static final int WM_RBUTTONDBLCLK = 518;
    protected static final int WM_MBUTTONDOWN = 519;
    protected static final int WM_MBUTTONUP = 520;
    protected static final int WM_MBUTTONDBLCLK = 521;
    protected static final int WM_NCMOUSEMOVE = 160;
    protected static final int WM_GETMINMAXINFO = 36;
    protected static final int WM_SIZE = 5;
    protected static final int WM_ACTIVATE = 6;
    protected static final int WM_QUERYNEWPALETTE = 783;
    protected static final int WM_PALETTECHANGED = 785;
    protected static final int WM_COMMAND = 273;
    protected static final int WM_KEYDOWN = 256;
    protected static final int WM_KEYUP = 257;
    protected static final int WM_CHAR = 258;
    protected static final int WM_SETCURSOR = 32;
    protected static final int WM_DESTROY = 2;
    protected static final int WM_ERASEBKGND = 20;
    protected static final int WM_WINDOWPOSCHANGED = 71;
    protected static final int MK_LBUTTON = 1;
    protected static final int MK_RBUTTON = 2;
    protected static final int MK_SHIFT = 4;
    protected static final int MK_CONTROL = 8;
    protected static final int MK_MBUTTON = 16;
    protected static final int MK_XBUTTON1 = 32;
    protected static final int MK_XBUTTON2 = 64;

    public JIDLEvent(long l, int n, int n2, int n3) {
        this.m_hwnd = l;
        this.m_msg = n;
        this.m_wp = n2;
        this.m_lp = n3;
    }

    public long getHwnd() {
        return this.m_hwnd;
    }

    public int getMsg() {
        return this.m_msg;
    }

    public int getWp() {
        return this.m_wp;
    }

    public int getLp() {
        return this.m_lp;
    }

    protected static boolean isMouseMotionEvent(int n) {
        boolean bl = false;
        if (n == 512 || n == 160) {
            bl = true;
        }
        return bl;
    }

    protected static boolean isKeyEvent(int n) {
        boolean bl = false;
        if (n == 256 || n == 257) {
            bl = true;
        }
        return bl;
    }

    protected static boolean isMouseEvent(int n) {
        boolean bl = false;
        if (n >= 513 && n <= 521) {
            bl = true;
        }
        return bl;
    }

    protected static MouseEvent createMouseEvent(Component component, int n, int n2, int n3) {
        MouseEvent mouseEvent = null;
        int n4 = n2 & 0xFFFF;
        int n5 = (n2 & 0xFFFF0000) >>> 16;
        int n6 = 0;
        int n7 = 0;
        long l = new Date().getTime();
        if ((n3 & 8) == 8) {
            n6 |= 2;
        }
        if ((n3 & 4) == 4) {
            n6 |= 1;
        }
        boolean bl = false;
        if ((n3 & 1) == 1) {
            n6 |= 0x10;
            bl = true;
        }
        if ((n3 & 0x10) == 16) {
            n6 |= 8;
            bl = true;
        }
        if ((n3 & 2) == 2) {
            n6 |= 4;
            bl = true;
        }
        switch (n) {
            case 512: {
                if (bl) {
                    n7 = 506;
                    break;
                }
                n7 = 503;
                break;
            }
            case 513: {
                n6 |= 0x10;
                n7 = 501;
                break;
            }
            case 514: {
                n6 |= 0x10;
                n7 = 502;
                break;
            }
            case 519: {
                n6 |= 8;
                n7 = 501;
                break;
            }
            case 520: {
                n6 |= 8;
                n7 = 502;
                break;
            }
            case 516: {
                n6 |= 4;
                n7 = 501;
                break;
            }
            case 517: {
                n6 |= 4;
                n7 = 502;
                break;
            }
            default: {
                System.out.println("ERR* event not recognized");
            }
        }
        if (n7 != 0) {
            mouseEvent = new MouseEvent(component, n7, l, n6, n4, n5, 1, false);
        }
        return mouseEvent;
    }

    protected static KeyEvent createKeyEvent(Component component, int n, int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n4 = 0;
        int n5 = 0;
        KeyEvent keyEvent = null;
        long l = new Date().getTime();
        char c = (char)n3;
        int n6 = n3;
        switch (n) {
            case 256: {
                n5 = 401;
                break;
            }
            case 257: {
                n5 = 402;
                break;
            }
            default: {
                System.out.println("ERR* event not recognized");
            }
        }
        if (bl) {
            n4 |= 1;
            c = Character.toUpperCase(c);
        } else {
            c = Character.toLowerCase(c);
        }
        if (bl2) {
            n4 |= 2;
        }
        if (bl3) {
            n4 |= 8;
        }
        if (bl4) {
            n4 |= 4;
        }
        if (n5 != 0) {
            keyEvent = new KeyEvent(component, n5, l, n4, n6, c);
        }
        return keyEvent;
    }

    protected static String getModifierDebugInfo(InputEvent inputEvent) {
        int n = inputEvent.getModifiers();
        String string = "mods=0x" + Integer.toHexString(n) + " (" + ((n & 0x10) == 16 ? "BUTTON1_MASK " : "") + ((n & 8) == 8 ? "BUTTON2_MASK " : "") + ((n & 4) == 4 ? "BUTTON3_MASK " : "") + ((n & 0x20) == 32 ? "ALT_GRAPH_MASK " : "") + ((n & 8) == 8 ? "ALT_MASK " : "") + ((n & 2) == 2 ? "CTRL_MASK " : "") + ((n & 4) == 4 ? "META_MASK " : "") + ((n & 1) == 1 ? "SHIFT_MASK " : "") + ")";
        return string;
    }

    public String toString() {
        return "JIDLEvent [hwnd=" + this.getHwnd() + " msg=" + this.getMsg() + " wparam=0x" + Integer.toHexString(this.getWp()) + " lparam=0x" + Integer.toHexString(this.getLp()) + "]";
    }

    public static void printKeyInfo(String string, KeyEvent keyEvent) {
        System.out.println("" + string + " KeyChar:" + keyEvent.getKeyChar() + " KeyCode:" + keyEvent.getKeyCode() + " " + JIDLEvent.getModifierDebugInfo(keyEvent));
    }

    public static void printMouseInfo(String string, MouseEvent mouseEvent) {
        System.out.println("" + string + " (" + mouseEvent.getX() + "," + mouseEvent.getY() + ")" + " " + JIDLEvent.getModifierDebugInfo(mouseEvent));
    }
}

