/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.PixelGrabber;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RSIImageFrame
extends JFrame {
    String m_sFile;
    RSIImageArea m_imgArea;
    int m_xsize;
    int m_ysize;
    Point m_point = null;

    public RSIImageFrame(String string, String string2, int n, int n2) {
        super(string);
        this.setDefaultCloseOperation(2);
        this.m_xsize = n;
        this.m_ysize = n2;
        this.m_sFile = string2;
        this.buildGUI();
    }

    public void buildGUI() {
        this.m_imgArea = new RSIImageArea(this.m_sFile, new Dimension(this.m_xsize, this.m_ysize));
        this.m_imgArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (RSIImageFrame.this.m_point == null) {
                    RSIImageFrame.this.m_point = new Point(mouseEvent.getX(), mouseEvent.getY());
                } else {
                    RSIImageFrame.this.m_point.x = mouseEvent.getX();
                    RSIImageFrame.this.m_point.y = mouseEvent.getY();
                }
                RSIImageFrame.this.repaint();
            }
        });
        Box box = Box.createVerticalBox();
        box.add(new JLabel("Click on map to update IDL globe."));
        box.add(this.m_imgArea);
        this.getContentPane().add(box);
        this.pack();
        this.setVisible(true);
    }

    /*
     * WARNING - void declaration
     */
    public byte[][][] getImageData() {
        byte[][][] byArray = null;
        int n = 1;
        int n2 = 1;
        n = this.m_imgArea.getWidth();
        n2 = this.m_imgArea.getHeight();
        if (n > 0 && n2 > 0) {
            int[] nArray = new int[n * n2];
            byArray = new byte[3][n][n2];
            PixelGrabber pixelGrabber = new PixelGrabber(this.m_imgArea.getImageObj(), 0, 0, n, n2, nArray, 0, n);
            try {
                boolean n3 = pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("pixel grab interrupted");
                return byArray;
            }
            boolean bl = false;
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    void var6_9;
                    n3 = nArray[++var6_9];
                    byArray[0][j][i] = (byte)(n3 >> 16 & 0xFF);
                    byArray[1][j][i] = (byte)(n3 >> 8 & 0xFF);
                    byArray[2][j][i] = (byte)(n3 & 0xFF);
                }
            }
        }
        return byArray;
    }

    public int[] getLastCursorPos(boolean bl) {
        int[] nArray = new int[]{0, 0};
        if (this.m_point != null) {
            nArray[0] = this.m_point.x;
            nArray[1] = bl ? this.m_imgArea.getHeight() - this.m_point.y : this.m_point.y;
        }
        return nArray;
    }

    public static void main(String[] stringArray) {
        RSIImageFrame rSIImageFrame = new RSIImageFrame("testing", "d:\\rsi\\idl61\\examples\\data\\avhrr.png", 720, 360);
    }
}

