/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JComponent;

public class RSIImageArea
extends JComponent {
    protected BufferedImage m_img;

    public RSIImageArea(String string, Dimension dimension) {
        this.loadImage(string);
        this.setPreferredSize(dimension);
        this.setSize(dimension);
    }

    public BufferedImage getImageObj() {
        return this.m_img;
    }

    public int getHeight() {
        return this.m_img.getHeight();
    }

    public int getWidth() {
        return this.m_img.getWidth();
    }

    public void paint(Graphics graphics) {
        Rectangle rectangle = this.getBounds();
        if (this.m_img != null) {
            graphics.drawImage(this.m_img, 0, 0, rectangle.width, rectangle.height, this);
        }
    }

    protected void loadImage(String string) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(new File(string));
        }
        catch (Exception exception) {
            bufferedImage = null;
        }
        if (bufferedImage == null) {
            System.err.println("Error: File " + string + " could not be loaded");
        }
        this.m_img = bufferedImage;
    }
}

